/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.log;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.log.LogBlockFilter;
import com.ibm.hwmca.fw.log.LogEntryId;
import com.ibm.hwmca.fw.log.LogErrorIds;
import com.ibm.hwmca.fw.log.Logger;
import com.ibm.hwmca.fw.util.BinaryNumber;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.ObjectDumperAttributes;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.Translator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Log
implements Serializable,
Cloneable,
LogErrorIds {
    public static final String SYSTEM = "log";
    public static final String E4 = "e4";
    public static final long XLOG_RETRIEVE_FIRST = 4096L;
    public static final long XLOG_RETRIEVE_EARLIER = 8192L;
    public static final long XLOG_SEARCH_EARLIER = 12288L;
    public static final long XLOG_RETRIEVE_LAST = 16384L;
    public static final long XLOG_RETRIEVE_LATER = 32768L;
    public static final long XLOG_SEARCH_LATER = 49152L;
    private static final String TRACE_MASKT = "XFRMLOGT";
    private static final String TRACE_MASKF = "XFRMLOGF";
    private static final String TRACE_MASKD = "XFRMLOGD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "Log");
    private byte logClass;
    private byte logType;
    private short user;
    private String eventName;
    private Date timestamp;
    private long offset;
    private Throwable thrown;
    private String logId;
    private boolean isError = false;
    private boolean logged = false;
    private static final short FLAGS_NOT_SET = -1;
    private static final short VERSIONING_SUPPORTED = 1;
    private short flags = (short)-1;
    private short recordOption = 0;
    ArrayList dataBlocks;
    private int jniDataBlocks = 0;

    public Log(byte logClass, byte logType, short user, String eventName, Date timestamp, Throwable thrown, String logId, String towerData) {
        Trace.trace(TRACE_MASKT, "-> Log(logClass=0x" + HexString.toHex(logClass, true) + ",logType=0x" + HexString.toHex(logType, true) + ",user=0x" + HexString.toHex(user, true) + ",eventName=" + eventName);
        Trace.trace(TRACE_MASKT, "   timestamp=" + timestamp + ",thrown=" + thrown + ",logId=" + logId + ",towerData=" + towerData);
        if (thrown != null) {
            Trace.trace(TRACE_MASKF, thrown);
        }
        this.dataBlocks = new ArrayList();
        this.setLogClass(logClass);
        this.setLogType(logType);
        this.setUser(user);
        this.setEventName(eventName);
        this.setTimestamp(timestamp);
        this.setThrowable(thrown);
        this.setLogId(logId);
        this.setTowerData(towerData);
        Trace.trace(TRACE_MASKT, "<- Log()");
    }

    public Log() {
        this(0, 0, 0, null, null, null, null, null);
    }

    public void finalize() {
        Trace.trace(TRACE_MASKT, "<> finalize()");
        try {
            if (this.jniDataBlocks != 0) {
                Logger.getLogger().free(this.jniDataBlocks);
            }
        }
        catch (Throwable thrown) {
            Trace.trace(TRACE_MASKT, "Error caught in Log.finalize()");
            Trace.trace(TRACE_MASKT, thrown);
        }
    }

    public void setLogClass(byte logClass) {
        this.logClass = logClass;
    }

    public byte getLogClass() {
        return this.logClass;
    }

    public void setLogType(byte logType) {
        this.logType = logType;
    }

    public byte getLogType() {
        return this.logType;
    }

    public void setUser(short user) {
        this.user = user;
    }

    public short getUser() {
        return this.user;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
        if (eventName != null) {
            int size = eventName.length();
            if (size > 12) {
                size = 12;
            }
            this.eventName = eventName.substring(0, size);
        }
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public Long getOffset() {
        return new Long(this.offset);
    }

    public void setThrowable(Throwable thrown) {
        this.thrown = thrown;
        if (thrown instanceof HException) {
            this.setLogged(((HException)thrown).isLogged());
        }
    }

    public Throwable getThrowable() {
        return this.thrown;
    }

    public void setLogId(String logId) {
        if (logId == null) {
            logId = SYSTEM;
        }
        this.logId = logId;
    }

    public String getLogId() {
        return this.logId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTowerData(String towerData) {
        if (towerData != null) {
            LogBlock logBlock = this.getLogBlock((byte)-14);
            if (logBlock != null) {
                List blocks;
                List list = blocks = this.getBlocks();
                synchronized (list) {
                    blocks.remove(logBlock);
                }
            }
            this.add(Translator.toAscii(towerData), (byte)-14, null);
        }
    }

    public String getTowerData() {
        String result = "";
        LogBlock logBlock = this.getLogBlock((byte)-14);
        if (logBlock != null) {
            result = Translator.fromAscii((byte[])logBlock.getData()).trim();
        }
        return result;
    }

    public LogEntryId getLogEntryId() {
        return new LogEntryId(this.getLogId(), this.getLogClass(), this.getLogType(), this.getUser(), this.getTimestamp(), this.getOffset());
    }

    public boolean isError() {
        return this.isError;
    }

    public void setLogged(boolean logged) {
        this.logged = logged;
    }

    public boolean isLogged() {
        return this.logged;
    }

    public void add(Object logObject) {
        this.add((byte)-1, logObject, null);
    }

    public void add(byte blockId, Object logObject) {
        this.add(blockId, logObject, null);
    }

    public void add(Object logObject, ObjectDumperAttributes dumpAttribs) {
        this.add((byte)-1, logObject, dumpAttribs);
    }

    public void add(byte blockId, Object logObject, ObjectDumperAttributes dumpAttribs) {
        int unsignedBlockId = blockId & 0xFF;
        int unsignedLastBlockId = 239;
        if (unsignedBlockId > unsignedLastBlockId) {
            blockId = (byte)-1;
        }
        this.add(logObject, blockId, dumpAttribs);
    }

    public LogBlock[] getLogBlocks() {
        Trace.trace(TRACE_MASKD, "<> getLogBlocks()");
        LogBlock[] result = null;
        ArrayList<LogBlock> blocks = new ArrayList<LogBlock>(this.getBlocks());
        if (this.thrown != null) {
            StringWriter stack = new StringWriter();
            PrintWriter writer = new PrintWriter(stack);
            this.thrown.printStackTrace(writer);
            blocks.add(0, new LogBlock(-1, stack.toString(), null));
            if (this.thrown instanceof HException) {
                LogBlock[] hexcBlocks = ((HException)this.thrown).getDataBlocks();
                int ix = 0;
                while (ix < hexcBlocks.length) {
                    if (hexcBlocks[ix] != null) {
                        blocks.add(hexcBlocks[ix]);
                    }
                    ++ix;
                }
            }
        }
        if (this.jniDataBlocks != 0) {
            try {
                LogBlock[] jniLogBlocks = Logger.getLogger().getLogBlocks(this.jniDataBlocks);
                int ix = 0;
                while (ix < jniLogBlocks.length) {
                    if (jniLogBlocks[ix] != null) {
                        blocks.add(jniLogBlocks[ix]);
                    }
                    ++ix;
                }
            }
            catch (HException exc) {
                Trace.trace(TRACE_MASKF, "Error caught in getLogBlock()");
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        result = new LogBlock[blocks.size()];
        blocks.toArray(result);
        return result;
    }

    public LogBlock getLogBlock(byte blockId) {
        Trace.trace(TRACE_MASKD, "<> getLogBlock(blockId=0x" + HexString.toHex(blockId) + ")");
        LogBlock result = null;
        LogBlock[] blocks = this.getLogBlocks();
        int ix = 0;
        while (ix < blocks.length) {
            if (blocks[ix].getBlockId() == blockId) {
                result = blocks[ix];
                break;
            }
            ++ix;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        List blocks;
        Trace.trace(TRACE_MASKD, "<> removeAllData()");
        List list = blocks = this.getBlocks();
        synchronized (list) {
            blocks.clear();
        }
    }

    public LogEntryId log(LogAttributes attribs) {
        Trace.trace(TRACE_MASKT, "-> log(attribs=" + attribs + ")");
        if (attribs == null) {
            attribs = LogAttributes.DEFAULT;
        }
        LogEntryId result = null;
        try {
            if (!this.isLogged()) {
                this.isError = attribs.isError() || attribs.isDisplayAsError();
                result = Logger.getLogger().log(this, attribs);
                this.setLogged(true);
                Throwable thrown = this.getThrowable();
                if (thrown != null && thrown instanceof HException) {
                    ((HException)thrown).setLogged(true);
                }
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKT, exc);
        }
        Trace.trace(TRACE_MASKT, "<- log()");
        return result;
    }

    public LogEntryId log() {
        return this.log(null);
    }

    public static Log[] retrieve(LogEntryId entryId, long eventCount, long directionFlags) throws HException {
        Trace.trace(TRACE_MASKT, "-> retrieve(entryId=" + entryId + "eventCount=" + eventCount + "directionFlags=" + directionFlags + ")");
        Log[] result = null;
        Byte logClass = new Byte(entryId.getLogClass());
        Byte logType = new Byte(entryId.getLogType());
        Short user = new Short(entryId.getUser());
        Date date = entryId.getTimestamp();
        String logId = entryId.getLogId();
        Long offset = entryId.getOffset();
        try {
            boolean isVersioningSupported = Log.isVersioningSupported(logId);
            result = Logger.getLogger().retrieve(null, null, user, date, null, logId, offset, new Long(eventCount), new Long(directionFlags));
            int ix = 0;
            while (ix < result.length) {
                result[ix].flags = isVersioningSupported ? (short)1 : 0;
                ++ix;
            }
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            Trace.trace(TRACE_MASKT, "Exception on retrieve");
            Trace.trace(TRACE_MASKT, exc);
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- retrieve()");
        return result;
    }

    public static Log[] retrieve(Byte logClass, Byte logType, Short user, Date startTime, Date endTime, LogBlockFilter[] logBlockFilters, byte[] logBlockIds, Integer eventCount, String logId) throws HException {
        Trace.trace(TRACE_MASKT, "-> retrieve(logClass=0x" + HexString.toHex(logClass, true) + ",logType=0x" + HexString.toHex(logType, true) + ",user=" + (user == null ? "null" : "0x" + HexString.toHex(user, true)) + ",startTime=" + startTime + ",endTime=" + endTime + ",logBlockFilters=" + logBlockFilters + ",logBlockIds=" + logBlockIds + ",eventCount=" + eventCount + ",logId=" + logId + ")");
        Log[] result = null;
        try {
            boolean isVersioningSupported = Log.isVersioningSupported(logId);
            result = Logger.getLogger().retrieve(logClass, logType, user, startTime, endTime, logBlockFilters, logBlockIds, eventCount, logId);
            int ix = 0;
            while (ix < result.length) {
                result[ix].flags = isVersioningSupported ? (short)1 : 0;
                ++ix;
            }
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            Trace.trace(TRACE_MASKT, "Exception on retrieve");
            Trace.trace(TRACE_MASKT, exc);
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- retrieve()");
        return result;
    }

    public static Log[] retrieve(Byte logClass, Byte logType, Short user, Date startTime, Date endTime, LogBlockFilter[] logBlockFilters, byte[] logBlockIds, String logId) throws HException {
        return Log.retrieve(logClass, logType, user, startTime, endTime, logBlockFilters, logBlockIds, null, logId);
    }

    public static Log[] retrieve(Byte[] logClasses, Byte logType, Date startTime, Date endTime, String logId) throws HException {
        Trace.trace(TRACE_MASKT, "-> retrieve(logClasses=" + logClasses + ",logType=0x" + HexString.toHex(logType, true) + ",startTime=" + startTime + ",endTime=" + endTime + ",logId=" + logId + ")");
        Log[] result = null;
        try {
            boolean isVersioningSupported = Log.isVersioningSupported(logId);
            result = Logger.getLogger().retrieve(logClasses, logType, startTime, endTime, logId);
            int ix = 0;
            while (ix < result.length) {
                result[ix].flags = isVersioningSupported ? (short)1 : 0;
                ++ix;
            }
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            Trace.trace(TRACE_MASKT, "Exception on retrieve");
            Trace.trace(TRACE_MASKT, exc);
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- retrieve()");
        return result;
    }

    public static Log[] retrieveSummary(Byte[] logClasses, Byte logType, Date startTime, Date endTime, String logId) throws HException {
        Trace.trace(TRACE_MASKT, "-> retrieveSummary(logClasses=" + logClasses + ",logType=0x" + HexString.toHex(logType, true) + ",startTime=" + startTime + ",endTime=" + endTime + ",logId=" + logId + ")");
        Log[] result = null;
        try {
            boolean isVersioningSupported = Log.isVersioningSupported(logId);
            result = Logger.getLogger().retrieveSummary(logClasses, logType, startTime, endTime, logId, new Integer(0));
            int ix = 0;
            while (ix < result.length) {
                result[ix].flags = isVersioningSupported ? (short)1 : 0;
                ++ix;
            }
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            Trace.trace(TRACE_MASKT, "Exception on retrieve");
            Trace.trace(TRACE_MASKT, exc);
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- retrieveSummary()");
        return result;
    }

    public static Log retrieve(LogEntryId entryId) throws HException {
        Trace.trace(TRACE_MASKT, "-> retrieve(entryId=" + entryId + ")");
        Byte logClass = new Byte(entryId.getLogClass());
        Byte logType = new Byte(entryId.getLogType());
        Short user = new Short(entryId.getUser());
        Date date = entryId.getTimestamp();
        Log[] logs = Logger.getLogger().retrieve(new Byte[]{logClass}, logType, date, date, entryId.getLogId());
        Log result = null;
        if (logs.length > 0) {
            result = logs[0];
        }
        Trace.trace(TRACE_MASKT, "<- retrieve()");
        return result;
    }

    public static Log retrieve(byte[] entryId, String logId) throws HException {
        Trace.trace(TRACE_MASKT, "-> retrieve(entryId=" + HexString.toHex(entryId) + ",logId=" + logId + ")");
        Byte logClass = new Byte(entryId[0]);
        Byte logType = new Byte(entryId[1]);
        Short user = new Short((short)(entryId[2] << 8 | entryId[3]));
        byte[] dateArray = new byte[8];
        System.arraycopy(entryId, 4, dateArray, 0, 8);
        long dateValue = BinaryNumber.toLong(dateArray);
        Date date = new Date(dateValue);
        Log[] logs = Log.retrieve(logClass, logType, user, date, date, null, null, logId);
        Log result = null;
        if (logs.length > 0) {
            result = logs[0];
        }
        Trace.trace(TRACE_MASKT, "<- retrieve()");
        return result;
    }

    public void updateModifyBlock(byte[] newData) throws HException {
        Trace.trace(TRACE_MASKT, "-> updateModifyBlock(newData=" + newData + ")");
        if (this.getTimestamp() == null) {
            throw new IllegalStateException("Timestamp is null");
        }
        try {
            Logger.getLogger().updateModifyBlock(this.getLogEntryId(), newData);
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            new FrameworkLog(classLogInfo, 17, hexc).log();
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- updateModifyBlock()");
    }

    public static void updateModifyBlock(LogEntryId entryId, byte[] newData) throws HException {
        Trace.trace(TRACE_MASKT, "-> updateModifyBlock(entryId=" + entryId + ", newData=" + newData + ")");
        Logger.getLogger().updateModifyBlock(entryId, newData);
        Trace.trace(TRACE_MASKT, "<- updateModifyBlock()");
    }

    public static void updateModifyBlock(byte[] entryId, byte[] newData, String logId) throws HException {
        Trace.trace(TRACE_MASKT, "-> updateModifyBlock(entryId=" + HexString.toHex(entryId) + ", newData=" + newData + ", logId=" + logId + ")");
        byte[] dateArray = new byte[8];
        System.arraycopy(entryId, 4, dateArray, 0, 8);
        long dateValue = BinaryNumber.toLong(dateArray);
        LogEntryId id = new LogEntryId(logId, entryId[0], entryId[1], (short)(entryId[2] << 8 | entryId[3]), new Date(dateValue));
        Logger.getLogger().updateModifyBlock(id, newData);
        Trace.trace(TRACE_MASKT, "<- updateModifyBlock()");
    }

    public static int getSize(String logId) {
        Trace.trace(TRACE_MASKT, "-> getSize(logId=" + logId + ")");
        int result = 0;
        try {
            byte[] logHeader = Logger.getLogger().getLogHeader(logId);
            Trace.trace(TRACE_MASKF, "logHeader=", logHeader);
            result = (logHeader[13] & 0xFF) << 24 | (logHeader[12] & 0xFF) << 16 | (logHeader[11] & 0xFF) << 8 | logHeader[10] & 0xFF;
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKT, exc);
        }
        Trace.trace(TRACE_MASKT, "<- getSize(returns " + result + ")");
        return result;
    }

    public static int getMaxSize(String logId) {
        Trace.trace(TRACE_MASKT, "-> getMaxSize(logId=" + logId + ")");
        int result = 0;
        try {
            byte[] logHeader = Logger.getLogger().getLogHeader(logId);
            Trace.trace(TRACE_MASKF, "logHeader=", logHeader);
            result = ((logHeader[1] & 0xFF) << 8 | logHeader[0] & 0xFF) * 2 * 1024;
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKT, exc);
        }
        Trace.trace(TRACE_MASKT, "<- getMaxSize(returns " + result + ")");
        return result;
    }

    public static boolean isVersioningSupported(String logId) {
        Trace.trace(TRACE_MASKT, "-> isVersioningSupported(logId=" + logId + ")");
        boolean result = false;
        try {
            byte[] logHeader = Logger.getLogger().getLogHeader(logId);
            result = (logHeader[1039] & 1) != 0;
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKT, exc);
        }
        Trace.trace(TRACE_MASKT, "<- isVersioningSupported(returns " + result + ")");
        return result;
    }

    public boolean isVersioningSupported() {
        Trace.trace(TRACE_MASKT, "-> isVersioningSupported()");
        if (this.flags == -1) {
            this.flags = Log.isVersioningSupported(this.getLogId()) ? (short)1 : 0;
        }
        boolean result = (this.flags & 1) != 0;
        Trace.trace(TRACE_MASKT, "<- isVersioningSupported()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Log result;
        block8: {
            result = null;
            try {
                result = (Log)super.clone();
                if (this.timestamp != null) {
                    result.timestamp = (Date)this.timestamp.clone();
                }
                ArrayList arrayList = this.dataBlocks;
                synchronized (arrayList) {
                    result.dataBlocks = (ArrayList)this.dataBlocks.clone();
                }
                try {
                    if (result.jniDataBlocks == 0) break block8;
                    Logger.getLogger().incrementRefCount(result.jniDataBlocks);
                }
                catch (HException exc) {
                    Trace.trace(TRACE_MASKF, exc);
                }
            }
            catch (CloneNotSupportedException exc) {}
        }
        return result;
    }

    public int hashCode() {
        int result = this.user + this.logClass + this.logType;
        if (this.timestamp != null) {
            result += this.timestamp.hashCode();
        }
        return result;
    }

    public boolean equals(Object test) {
        boolean result = false;
        if (test instanceof Log) {
            boolean bl = result = this.user == ((Log)test).user && this.logClass == ((Log)test).logClass && this.logType == ((Log)test).logType;
            result = this.timestamp == null ? result && ((Log)test).timestamp == null : result && this.timestamp.equals(((Log)test).timestamp);
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append("@").append(this.hashCode()).append("[0x").append(HexString.toHex(this.getLogClass(), true)).append(",0x").append(HexString.toHex(this.getLogType(), true)).append(",0x").append(HexString.toHex(this.getUser(), true)).append(",").append(this.getTimestamp()).append(",").append(this.getLogId()).append("]");
        return result.toString();
    }

    protected List getBlocks() {
        return this.dataBlocks;
    }

    void add(Object logObject, byte blockId, ObjectDumperAttributes dumpAttribs) {
        this.add(logObject, blockId, dumpAttribs, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Object logObject, byte blockId, ObjectDumperAttributes dumpAttribs, int index) {
        List blocks;
        Trace.trace(TRACE_MASKF, "-> add(blockId=" + (blockId == -1 ? "AUTO" : "0x" + HexString.toHex(blockId, true)) + ",dumpAttribs=" + dumpAttribs + ")");
        LogBlock logBlock = new LogBlock(blockId, logObject, dumpAttribs);
        List list = blocks = this.getBlocks();
        synchronized (list) {
            if (index == -1) {
                blocks.add(logBlock);
            } else {
                blocks.add(index, logBlock);
            }
        }
        Trace.trace(TRACE_MASKF, "<- add()");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            if (this.jniDataBlocks != 0) {
                Logger.getLogger().incrementRefCount(this.jniDataBlocks);
            }
        }
        catch (HException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
    }
}

